/**
 * 
 */
package com.ejie.ab18a.control;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ejie.ab18a.utils.Ab18aO75Utils;
import com.ejie.ab18a.utils.Constantes;
import com.ejie.ab18a.utils.Utilidades;

/**
 * @author XXXX
 * 
 */
@Controller()
@RequestMapping(value = "lanzarProcIncoherencias")
public class Ab18aLanzarProcesoIncoherenciasController {

	private static final String AB18A_INCOHERENCIAS_SH = "AB18AINCO.sh";

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory.getLogger(Ab18aLanzarProcesoIncoherenciasController.class);

	/** The message source. */
	@Resource()
	private ReloadableResourceBundleMessageSource messageSource;

	/**
	 * Generacion informes batch.
	 * 
	 * @param request
	 *            the request
	 * @return the string
	 * @throws Exception
	 *             the exception
	 */
	@SuppressWarnings("unused")
	@RequestMapping(method = RequestMethod.GET)
	private String lanzarEnviarPeticionBatch(HttpServletRequest request) throws Exception {
		// realizar proceso batch
		String ficheroSH = AB18A_INCOHERENCIAS_SH;

		String sDescripcion = "PROCESO INCOHERENCIAS";

		Ab18aO75Utils o75Utils = Ab18aO75Utils.getInstance();

		String resultado = o75Utils.lanzarProceso(request, ficheroSH, sDescripcion, null, null);

		if (Utilidades.notNullAndNotEmpty(resultado) && resultado.equalsIgnoreCase(Constantes.CTE_TRUE)) {
			return "ab18a02s00";
		} else {

			Ab18aLanzarProcesoIncoherenciasController.logger.error("lanzarEnviarPeticionBatch: errorCodigo: " + o75Utils.getlErrorCodigo()
					+ ", Error descripcion: " + o75Utils.getsErrorDescripcion() + ", error motivo: " + o75Utils.getsErrorMotivo());

			return "error";
		}
	}
}
